package modul;

import java.awt.EventQueue;
import java.util.ArrayList;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.JComboBox;
import javax.swing.JButton;
import javax.swing.JLabel;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class Aenderungsfenster extends JFrame {

	/**
	 * 
	 */
	private static final long serialVersionUID = -5996175141631172854L;
	private JPanel contentPane;
	private DefaultComboBoxModel cbmDatensatz = new DefaultComboBoxModel();
	private Hauptfenster dieOberflaeche;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					Aenderungsfenster frame = new Aenderungsfenster(null,null);
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public Aenderungsfenster(Hauptfenster pO, ArrayList pListe) {
		this.dieOberflaeche = pO;
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 541, 170);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(null);
		
		JComboBox cbDatensatz = new JComboBox();
		cbDatensatz.setModel(cbmDatensatz);
		cbDatensatz.setBounds(35, 41, 480, 20);
		initialisiereCB(pListe);
		contentPane.add(cbDatensatz);
		
		JButton btWaehlen = new JButton("\u00C4ndern");
		btWaehlen.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				aendern();
			}
		});
		btWaehlen.setBounds(35, 89, 142, 23);
		contentPane.add(btWaehlen);
		
		JLabel lbDatensatz = new JLabel("Datensatz ausw\u00E4hlen:");
		lbDatensatz.setBounds(35, 11, 142, 14);
		contentPane.add(lbDatensatz);
		
		JButton btSchiessen = new JButton("Schlie\u00DFen");
		btSchiessen.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				setVisible(false);
			}
		});
		btSchiessen.setBounds(187, 89, 155, 23);
		contentPane.add(btSchiessen);
	}
	
	private void initialisiereCB(ArrayList<Object> pListe ){
		cbmDatensatz.removeAllElements();
		for(int i=0; i< pListe.size();i++){
			Object o = pListe.get(i);
			cbmDatensatz.addElement(o);
		}
	}
	
	private void aendern(){
		Lehrer mLehrer;
		switch(dieOberflaeche.getOption()){
			case 3:
				mLehrer = (Lehrer) cbmDatensatz.getSelectedItem();
				dieOberflaeche.getVerwaltung().setDerLehrer(mLehrer);
				dieOberflaeche.setVisible(true);
				dieOberflaeche.schreibeLehrer();
				dieOberflaeche.getTabbedPane().setSelectedIndex(1);
				dieOberflaeche.validate();								
				break;
			case 7:
				String mTermin = (String) cbmDatensatz.getSelectedItem();
				String[] mTermindatensatz = mTermin.split(" \t ");
				
				String mLehrer_name = mTermindatensatz[0];
				String mLehrer_vorname = mTermindatensatz[1];
				String mLehrer_kuerzel = mTermindatensatz[2];
				mLehrer = new Lehrer(mLehrer_name,mLehrer_vorname,mLehrer_kuerzel);				
				dieOberflaeche.getVerwaltung().setDerLehrer(mLehrer);
				
				String mEzb_name = mTermindatensatz[3];
				String mEzb_vorname = mTermindatensatz[4];
				String mEzb_klassenangabe = mTermindatensatz[5];
				Erziehungsberechtigter mEzb = new Erziehungsberechtigter(mEzb_name,mEzb_vorname,mEzb_klassenangabe);
				dieOberflaeche.getVerwaltung().setDerEzb(mEzb);
				
				String mZeitraum = mTermindatensatz[6];	
				String[] mZeitraumdatensatz = mZeitraum.split(" - ");
				String mVon_stunde = mZeitraumdatensatz[0].substring(0, 2);
				String mVon_min = mZeitraumdatensatz[0].substring(3, 5);
				Uhrzeit mUhrzeit_von = new Uhrzeit(mVon_stunde,mVon_min);
				
				String mBis_stunde = mZeitraumdatensatz[1].substring(0, 2);
				String mBis_min = mZeitraumdatensatz[1].substring(3, 5);
				Uhrzeit mUhrzeit_bis = new Uhrzeit(mBis_stunde,mBis_min);
				
				Zeitraum mZeit = new Zeitraum(mUhrzeit_von,mUhrzeit_bis);
				dieOberflaeche.getVerwaltung().setZeitraum(mZeit);
				dieOberflaeche.setVisible(true);
				dieOberflaeche.schreibeTermin();
				dieOberflaeche.getTabbedPane().setSelectedIndex(0);
				dieOberflaeche.validate();
				break;			
		}
				
	}
}
