package modul;

import java.util.ArrayList;

public class Benutzer {
	
	//Attribute: Eigenschaften von Ojekten dieser Klasse
	private int idBenutzer;
	private String name;
	private String vorname;
	private String passwort;
	private int status;
	private int recht;
	private boolean ist_verfuegbar;
	private Termin derTermin;
	private ArrayList<Termin> terminliste = new ArrayList<Termin>();
	
	//Konstruktor: Erzeugt Objekte dieser Klasse
	public Benutzer(String pName, String pVorname){
		this.name = pName;
		this.vorname = pVorname;
		this.ist_verfuegbar = true;
	}
	
	
	//GETTER: Ermittelt Eigenschaftswerte eines Objektes einer Klasse
	public int getIdBenutzer() {
		return idBenutzer;
	}
	
	public String getName() {
		return name;
	}
	
	public String getVorname() {
		return vorname;
	}
	
	public String getPasswort() {
		return passwort;
	}
	
	public int getStatus() {
		return status;
	}
	
	public int getRecht() {
		return recht;
	}
	
	public boolean getIstVerfuebar() {
		return ist_verfuegbar;
	}

	public Termin getDerTermin() {
		return derTermin;
	}

	public ArrayList<Termin> getTerminliste() {
		return terminliste;
	}
	
	//SETTER: bermittelt Eigenschaftswert an das Objekt der Klasse
	public void setIdBenutzer(int pIdBenutzer) {
		this.idBenutzer = pIdBenutzer;
	}

	public void setName(String pName) {
		this.name = pName;
	}

	public void setVorname(String pVorname) {
		this.vorname = pVorname;
	}

	public void setPasswort(String pPasswort) {
		this.passwort = pPasswort;
	}

	public void setStatus(int pStatus) {
		this.status = pStatus;
	}

	public void setRecht(int pRecht) {
		this.recht = pRecht;
	}	
	
	public void setIst_Verfuegbar(boolean pIst_verfuegbar) {
		this.ist_verfuegbar = pIst_verfuegbar;
	}
		
	public void setDerTermin(Termin pTermin) {
		this.derTermin = pTermin;
	}
	
	//Sonstige Methoden
	public void addTermin(Termin pTermin){
		this.terminliste.add(pTermin);
	}
	
	public Termin holeTermin(int pStelle){
		return this.terminliste.get(pStelle);
	}

	public boolean pruefeTermin(Termin pTermin){
		if (this.getTerminliste().contains(pTermin)) {
			return true;
		}else{
			return false;
		} // end of if
	}
	
	
	public String toString(){
		String tab = " \t ";
		return this.name + tab + this.vorname;
	}
}
