package modul;

import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.JTabbedPane;
import javax.swing.JLabel;
import java.awt.Font;
import java.awt.Color;

import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JButton;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JRadioButton;
import javax.swing.ButtonGroup;
import javax.swing.JPasswordField;



public class Hauptfenster extends JFrame {

	/**
	 * 
	 */
	private static final long serialVersionUID = 2282208555580552741L;
	private JPanel contentPane;
	private JTextField tfName;
	private JTextField tfVorname;
	private JComboBox cbLehrerliste;
	private JComboBox cbZeitraeume;
	private DefaultComboBoxModel cbmLehrer = new DefaultComboBoxModel();
	private DefaultComboBoxModel cbmZeitraum = new DefaultComboBoxModel();
	private Liste dieVerwaltung = new Liste();
	private Listenverwaltung alleDaten = new Listenverwaltung(dieVerwaltung);
	private JTextField tfName_l;
	private JTextField tfVorname_l;
	private JTextField tfKuerzel;
	private JTextField tfKlasse;
	private JTextField tfRaum;
	private JTextField tfVon;
	private JTextField tfBis;
	private final ButtonGroup rbgLehrerliste = new ButtonGroup();
	private final ButtonGroup rbgTerminliste = new ButtonGroup();
	private JTextField tfRecht;
	private JTextField tfStatus;
	private JRadioButton rbLehrerliste_anzeigen;
	private JRadioButton rbLehrer_aendern;
	private JRadioButton rbLehrer_loeschen;
	private JRadioButton rbTerminliste;
	private JRadioButton rbTermine_lehrer;
	private JRadioButton rbTermin_loeschen;
	private JRadioButton rbTermin_aendern;
	private JRadioButton rb_istVerfuegbar;
	private boolean l_eingefuegt=false; 
	private boolean z_eingefuegt=false;
	private int option = 0;
	private JTabbedPane taVerwaltung;

	private JPanel paTermin;
	private JPanel paLehrer;
	private JPasswordField tfPasswort;
	private JPasswordField tfWiederholung;
	private JTextField tfKlassenangabe;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					Hauptfenster frame = new Hauptfenster();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public Hauptfenster() {
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 378, 483);
		contentPane = new JPanel();
		contentPane.setBackground(Color.WHITE);
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(null);

		taVerwaltung = new JTabbedPane(JTabbedPane.TOP);
		taVerwaltung.setBounds(0, 66, 362, 329);
		contentPane.add(taVerwaltung);

		paTermin = new JPanel();
		taVerwaltung.addTab("Termin", null, paTermin, null);
		paTermin.setLayout(null);

		JLabel lbLehrerliste = new JLabel("Lehrer ausw\u00E4hlen:");
		lbLehrerliste.setBounds(10, 131, 123, 14);
		paTermin.add(lbLehrerliste);

		cbLehrerliste = new JComboBox();
		cbLehrerliste.setModel(cbmLehrer);
		initialisiereCBLehrerliste();

		cbLehrerliste.setBounds(10, 149, 192, 20);
		paTermin.add(cbLehrerliste);

		JLabel lbZeitraum = new JLabel("Zeitraum ausw\u00E4hlen:");
		lbZeitraum.setBounds(10, 180, 123, 14);
		paTermin.add(lbZeitraum);

		cbZeitraeume = new JComboBox();
		cbZeitraeume.setModel(cbmZeitraum);
		initialisiereCBZeitraum();


		cbZeitraeume.setBounds(10, 205, 192, 20);
		paTermin.add(cbZeitraeume);


		JLabel lbBenutzer = new JLabel("Erziehungsberechtigter:");
		lbBenutzer.setBounds(10, 11, 144, 14);
		paTermin.add(lbBenutzer);

		JLabel lbName = new JLabel("Name:");
		lbName.setBounds(10, 36, 63, 14);
		paTermin.add(lbName);

		tfName = new JTextField();
		tfName.setText("tfName");
		tfName.setBounds(83, 33, 264, 20);
		paTermin.add(tfName);
		tfName.setColumns(10);

		JLabel lbVorname = new JLabel("Vorname:");
		lbVorname.setBounds(10, 71, 63, 14);
		paTermin.add(lbVorname);

		tfVorname = new JTextField();
		tfVorname.setText("tfVorname");
		tfVorname.setBounds(83, 64, 264, 20);
		paTermin.add(tfVorname);
		tfVorname.setColumns(10);

		//###########EREIGNISSTEUERUNG
		JButton btTermin = new JButton("Termin vereinbaren");
		btTermin.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				termin_vereinbaren();
			}
		});
		btTermin.setBounds(10, 243, 337, 23);
		paTermin.add(btTermin);

		JLabel lbKlasse = new JLabel("Klasse:");
		lbKlasse.setBounds(10, 106, 46, 14);
		paTermin.add(lbKlasse);

		tfKlassenangabe = new JTextField();
		tfKlassenangabe.setText("tfKlassenangabe");
		tfKlassenangabe.setBounds(83, 100, 264, 20);
		paTermin.add(tfKlassenangabe);
		tfKlassenangabe.setColumns(10);

		JPanel paLehrer = new JPanel();
		taVerwaltung.addTab("Lehrer", null, paLehrer, null);
		paLehrer.setLayout(null);

		JLabel lbName_l = new JLabel("Name des Lehrers:");
		lbName_l.setBounds(10, 23, 120, 31);
		paLehrer.add(lbName_l);

		tfName_l = new JTextField();
		tfName_l.setText("tfName_l");
		tfName_l.setBounds(20, 53, 153, 20);
		paLehrer.add(tfName_l);
		tfName_l.setColumns(10);

		JLabel lbVorname_l = new JLabel("Vorname des Lehrers:");
		lbVorname_l.setBounds(10, 84, 132, 31);
		paLehrer.add(lbVorname_l);

		tfVorname_l = new JTextField();
		tfVorname_l.setText("tfVorname_l");
		tfVorname_l.setBounds(20, 115, 153, 20);
		paLehrer.add(tfVorname_l);
		tfVorname_l.setColumns(10);

		JLabel lbKuerzel = new JLabel("K\u00FCrzel:");
		lbKuerzel.setBounds(220, 28, 90, 20);
		paLehrer.add(lbKuerzel);

		tfKuerzel = new JTextField();
		tfKuerzel.setText("tfKuerzel");
		tfKuerzel.setBounds(220, 53, 120, 20);
		paLehrer.add(tfKuerzel);
		tfKuerzel.setColumns(10);

		JLabel lbKlassenlehrer = new JLabel("Ist Klassenlehrer in:");
		lbKlassenlehrer.setBounds(220, 89, 127, 20);
		paLehrer.add(lbKlassenlehrer);

		tfKlasse = new JTextField();
		tfKlasse.setText("tfKlasse");
		tfKlasse.setBounds(220, 115, 120, 20);
		paLehrer.add(tfKlasse);
		tfKlasse.setColumns(10);

		JLabel lbRaum = new JLabel("Raum:");
		lbRaum.setBounds(10, 157, 81, 20);
		paLehrer.add(lbRaum);

		tfRaum = new JTextField();
		tfRaum.setText("tfRaum");
		tfRaum.setBounds(20, 188, 90, 20);
		paLehrer.add(tfRaum);
		tfRaum.setColumns(10);

		//###########EREIGNISSTEUERUNG
		JButton btHinzufuegen_l = new JButton("Lehrer hinzuf\u00FCgen");
		btHinzufuegen_l.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				lehrer_hinzufuegen();
			}
		});
		btHinzufuegen_l.setBounds(20, 219, 153, 23);
		paLehrer.add(btHinzufuegen_l);

		//###########EREIGNISSTEUERUNG
		JButton btSuche_Lehrer = new JButton("Suche Lehrer");
		btSuche_Lehrer.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				lehrer_suchen();
			}
		});
		btSuche_Lehrer.setBounds(183, 219, 153, 23);
		paLehrer.add(btSuche_Lehrer);
		
		JButton btAenderungen_uebernehmen = new JButton("\u00C4nderungen \u00FCbernehmen");
		btAenderungen_uebernehmen.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				lehrer_aendern();
			}
		});
		btAenderungen_uebernehmen.setBounds(20, 254, 316, 23);
		paLehrer.add(btAenderungen_uebernehmen);

		JPanel paZeitraum = new JPanel();
		taVerwaltung.addTab("Zeitraum", null, paZeitraum, null);
		paZeitraum.setLayout(null);

		JLabel lbVon = new JLabel("Von: ##:##");
		lbVon.setBounds(10, 10, 84, 27);
		paZeitraum.add(lbVon);

		tfVon = new JTextField();
		tfVon.setText("tfVon");
		tfVon.setBounds(20, 37, 106, 20);
		paZeitraum.add(tfVon);
		tfVon.setColumns(10);

		JLabel lbBis = new JLabel("Bis: ##:##");
		lbBis.setBounds(10, 69, 200, 27);
		paZeitraum.add(lbBis);

		tfBis = new JTextField();
		tfBis.setText("tfBis");
		tfBis.setBounds(20, 105, 106, 20);
		paZeitraum.add(tfBis);
		tfBis.setColumns(10);

		//###########EREIGNISSTEUERUNG
		JButton btHinzufuegen_Zeitraum = new JButton("Zeitraum hinzuf\u00FCgen");
		btHinzufuegen_Zeitraum.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				zeitraum_hinzufuegen();
			}
		});
		btHinzufuegen_Zeitraum.setBounds(8, 140, 339, 23);
		paZeitraum.add(btHinzufuegen_Zeitraum);

		//###########EREIGNISSTEUERUNG
		JButton btZeitraum_bearbeiten = new JButton("Zeitraum bearbeiten");
		btZeitraum_bearbeiten.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				zeitraum_bearbeiten();
			}
		});
		btZeitraum_bearbeiten.setBounds(10, 232, 337, 23);
		paZeitraum.add(btZeitraum_bearbeiten);

		JLabel lbZeitraum_auswaehlen = new JLabel("Zeitraum ausw\u00E4hlen:");
		lbZeitraum_auswaehlen.setBounds(10, 174, 123, 14);
		paZeitraum.add(lbZeitraum_auswaehlen);

		JComboBox cbZeitraum_bearbeiten = new JComboBox();
		cbZeitraum_bearbeiten.setBounds(17, 192, 186, 27);
		cbZeitraum_bearbeiten.setModel(cbmZeitraum);
		paZeitraum.add(cbZeitraum_bearbeiten);

		JPanel paListen = new JPanel();
		taVerwaltung.addTab("Listen verwalten", null, paListen, null);
		paListen.setLayout(null);

		JLabel lbLehrerliste_verwalten = new JLabel("Lehrerliste verwalten:");
		lbLehrerliste_verwalten.setBounds(10, 10, 134, 23);
		paListen.add(lbLehrerliste_verwalten);

		rbLehrerliste_anzeigen = new JRadioButton("Lehrerliste anzeigen");
		rbgLehrerliste.add(rbLehrerliste_anzeigen);
		rbLehrerliste_anzeigen.setBounds(10, 40, 189, 23);
		paListen.add(rbLehrerliste_anzeigen);

		rbLehrer_aendern = new JRadioButton("Lehrer aus Liste ausw\u00E4hlen und \u00E4ndern");
		rbgLehrerliste.add(rbLehrer_aendern);
		rbLehrer_aendern.setBounds(10, 92, 317, 23);
		paListen.add(rbLehrer_aendern);

		rbLehrer_loeschen = new JRadioButton("Lehrer aus Liste l\u00F6schen");
		rbgLehrerliste.add(rbLehrer_loeschen);
		rbLehrer_loeschen.setBounds(10, 66, 200, 23);
		paListen.add(rbLehrer_loeschen);

		//###########EREIGNISSTEUERUNG
		JButton btWeiter = new JButton("Weiter");
		btWeiter.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {

				//EINGABE
				int mOption = leseRadio();

				//VERARBEITUNG
				weiter(mOption);	
			}
		});
		btWeiter.setBounds(229, 255, 118, 23);
		paListen.add(btWeiter);

		JLabel lbTerminliste_verwalten = new JLabel("Terminliste verwalten:");
		lbTerminliste_verwalten.setBounds(10, 118, 200, 23);
		paListen.add(lbTerminliste_verwalten);

		rbTerminliste = new JRadioButton("Alle Termine anzeigen");
		rbgTerminliste.add(rbTerminliste);
		rbTerminliste.setBounds(11, 146, 222, 23);
		paListen.add(rbTerminliste);

		rbTermine_lehrer = new JRadioButton("Termine eines Lehrers anzeigen");
		rbgTerminliste.add(rbTermine_lehrer);
		rbTermine_lehrer.setBounds(11, 175, 290, 23);
		paListen.add(rbTermine_lehrer);

		rbTermin_loeschen = new JRadioButton("Termin aus Liste l\u00F6schen");
		rbgTerminliste.add(rbTermin_loeschen);
		rbTermin_loeschen.setBounds(11, 201, 222, 23);
		paListen.add(rbTermin_loeschen);

		rbTermin_aendern = new JRadioButton("Termin aus Liste ausw\u00E4hlen und \u00E4ndern");
		rbgTerminliste.add(rbTermin_aendern);
		rbTermin_aendern.setBounds(11, 227, 278, 23);
		paListen.add(rbTermin_aendern);

		JPanel paEinstellungen = new JPanel();
		taVerwaltung.addTab("Einstellungen", null, paEinstellungen, null);
		paEinstellungen.setLayout(null);

		JLabel lbBenutzereinstellung = new JLabel("Benutzerspezifische Einstellungen:");
		lbBenutzereinstellung.setBounds(10, 10, 200, 25);
		paEinstellungen.add(lbBenutzereinstellung);

		JLabel lbRecht = new JLabel("Recht festlegen:");
		lbRecht.setBounds(20, 41, 118, 25);
		paEinstellungen.add(lbRecht);

		tfRecht = new JTextField();
		tfRecht.setText("tfRecht");
		tfRecht.setBounds(148, 43, 86, 20);
		paEinstellungen.add(tfRecht);
		tfRecht.setColumns(10);

		JLabel lbStatus = new JLabel("Status festlegen:");
		lbStatus.setBounds(18, 70, 133, 29);
		paEinstellungen.add(lbStatus);

		tfStatus = new JTextField();
		tfStatus.setText("tfStatus");
		tfStatus.setBounds(148, 74, 86, 20);
		paEinstellungen.add(tfStatus);
		tfStatus.setColumns(10);

		rb_istVerfuegbar = new JRadioButton("Benutzer ist verf\u00FCgbar");
		rb_istVerfuegbar.setSelected(true);
		rb_istVerfuegbar.setBounds(10, 214, 224, 23);
		paEinstellungen.add(rb_istVerfuegbar);

		JLabel lbPasswort = new JLabel("Passwort setzen:");
		lbPasswort.setBounds(20, 101, 118, 29);
		paEinstellungen.add(lbPasswort);

		JLabel lbWiederholung = new JLabel("Passwort wiederholen:");
		lbWiederholung.setBounds(17, 156, 200, 29);
		paEinstellungen.add(lbWiederholung);

		//###########EREIGNISSTEUERUNG
		JButton btUebernehmen = new JButton("Benutzerspezifische Einstellungen \u00FCbernehmen");
		btUebernehmen.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				//VERARBEITUNG
				einstellungen_uebernehmen();	
			}
		});
		btUebernehmen.setBounds(10, 244, 337, 23);
		paEinstellungen.add(btUebernehmen);

		//###########EREIGNISSTEUERUNG
		JButton btInfo_recht = new JButton("Info");
		btInfo_recht.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				//EINGABE

				//VERARBEITUNG

				//AUSGABE
			}
		});
		btInfo_recht.setBounds(244, 41, 70, 23);
		paEinstellungen.add(btInfo_recht);

		//###########EREIGNISSTEUERUNG
		JButton btInfo_Status = new JButton("Info");
		btInfo_Status.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				//EINGABE

				//VERARBEITUNG

				//AUSGABE
			}
		});
		btInfo_Status.setBounds(244, 73, 70, 23);
		paEinstellungen.add(btInfo_Status);

		tfPasswort = new JPasswordField();
		tfPasswort.setBounds(30, 127, 204, 20);
		paEinstellungen.add(tfPasswort);

		tfWiederholung = new JPasswordField();
		tfWiederholung.setBounds(30, 184, 212, 20);
		paEinstellungen.add(tfWiederholung);

		JLabel lbTitel = new JLabel("Elternsprechtag");
		lbTitel.setFont(new Font("Arial", Font.PLAIN, 18));
		lbTitel.setBounds(4, 11, 190, 44);
		contentPane.add(lbTitel);

		JLabel lbLogo = new JLabel("");
		lbLogo.setIcon(new ImageIcon(Hauptfenster.class.getResource("/modul/bsw_logo_final_web.jpg")));
		lbLogo.setBounds(215, 0, 147, 62);
		contentPane.add(lbLogo);

		//###########EREIGNISSTEUERUNG
		JButton btLeeren = new JButton("Alle Eingabefelder leeren");
		btLeeren.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				leeren();
			}
		});
		btLeeren.setBounds(10, 411, 337, 23);
		contentPane.add(btLeeren);
	}
	
	public void setOption(int pOption){
		this.option = pOption;
	}
	
	public int getOption(){
		return this.option;
	}

	//###########SONSTIGE HILFSMETHODEN

	/*#######ComboBox: Initialisierung#####
	 * ####################################*/
	private void initialisiereCBLehrerliste(){
		cbmLehrer.removeAllElements();
		for(int i=0; i< dieVerwaltung.getLehrerliste().size();i++){			
			Lehrer l = dieVerwaltung.holeLehrer(i);
			cbmLehrer.addElement(l);
		}		
	}

	private void initialisiereCBZeitraum(){
		cbmZeitraum.removeAllElements();
		for(int i=0; i< dieVerwaltung.getZeitraeume().size();i++){
			Zeitraum z = dieVerwaltung.holeZeitraum(i);
			cbmZeitraum.addElement(z);
		}
	}
	
	public Liste getVerwaltung(){
		return dieVerwaltung;
	}
	
	public Listenverwaltung getAlleDaten(){
		return alleDaten;
	}
	
	public JTabbedPane getTabbedPane(){
		return this.taVerwaltung;
	}
	
	public JPanel getPaTermin(){
		return this.paTermin;
	}
	
	public JPanel getPaLehrer(){
		return this.paLehrer;
	}
	
	/*#######Lesemethoden#####
	 * ####################################*/
	private String leseName_l(){
		return tfName_l.getText();
	}

	private String leseVorname_l(){
		return tfVorname_l.getText();
	}

	private String leseKlasse(){
		return tfKlasse.getText();
	}

	private String leseKuerzel(){
		return tfKuerzel.getText();
	}

	private String leseRaum(){
		return tfRaum.getText();
	}

	private Uhrzeit leseVon(){
		String mVon_stunde = String.valueOf(tfVon.getText()).substring(0, 2);
		String mVon_minute = String.valueOf(tfVon.getText()).substring(3, 5);
		Uhrzeit mUhrzeit = new Uhrzeit(mVon_stunde,mVon_minute);

		return mUhrzeit;
	}

	private Uhrzeit leseBis(){
		String mBis_stunde = String.valueOf(tfBis.getText().substring(0, 2));
		String mVon_minute = String.valueOf(tfBis.getText()).substring(3, 5);
		Uhrzeit mUhrzeit = new Uhrzeit(mBis_stunde,mVon_minute);

		return mUhrzeit;
	}

	private int leseRadio(){
		int radio = 0;
		if(rbLehrerliste_anzeigen.isSelected()){
			radio = 1;			
		}else if(rbLehrer_loeschen.isSelected()){
			radio = 2;
		}else if(rbLehrer_aendern.isSelected()){
			radio = 3;
		}else if(rbTerminliste.isSelected()){
			radio = 4;
		}else if(rbTermine_lehrer.isSelected()){
			radio = 5;
		}else if(rbTermin_loeschen.isSelected()){
			radio = 6;
		}else if(rbTermin_aendern.isSelected()){
			radio = 7;
		}
		this.option = radio;
		System.out.println(radio);
		return radio;				
	}

	/*#######Schreibemethoden#####
	 * ####################################*/
	public void schreibeLehrer(){
		tfName_l.setText(dieVerwaltung.getDerLehrer().getName());
		tfVorname_l.setText(dieVerwaltung.getDerLehrer().getVorname());
		tfKuerzel.setText(dieVerwaltung.getDerLehrer().getKuerzel());
		tfKlasse.setText(dieVerwaltung.getDerLehrer().getKlassenlehrer_von());
		tfRaum.setText(dieVerwaltung.getDerLehrer().getIn_raum());
	}

	public void schreibeZeitraum(){
		tfVon.setText(dieVerwaltung.getDerZeitraum().getVon().toString());
		tfBis.setText(dieVerwaltung.getDerZeitraum().getBis().toString());		
	}
	
	public void schreibeTermin(){
		tfName_l.setText(dieVerwaltung.getDerLehrer().getName());
		tfVorname_l.setText(dieVerwaltung.getDerLehrer().getVorname());
		tfKuerzel.setText(dieVerwaltung.getDerLehrer().getKuerzel());
		tfName.setText(dieVerwaltung.getDerEzb().getName());
		tfVorname.setText(dieVerwaltung.getDerEzb().getName());
		tfKlassenangabe.setText(dieVerwaltung.getDerEzb().getKlasse());
		cbmLehrer.setSelectedItem(dieVerwaltung.getDerLehrer());
		cbmZeitraum.setSelectedItem(dieVerwaltung.getDerZeitraum());
	}

	private void leeren(){
		tfBis.setText("");
		tfKlasse.setText("");
		tfKuerzel.setText("");
		tfName.setText("");
		tfName_l.setText("");
		tfPasswort.setText("");
		tfRaum.setText("");
		tfRecht.setText("");
		tfStatus.setText("");
		tfVon.setText("");
		tfVorname.setText("");
		tfVorname_l.setText("");
		tfWiederholung.setText("");
		tfKlassenangabe.setText("");
	}

	//*#######Reservierung#####
	private void reservieren(Lehrer l, Erziehungsberechtigter e, Termin t){
		//Ordne zu
		dieVerwaltung.zuordnen( l, e, t.getDerZeitraum());

		//Ab jetzt belegt
		t.setBelegt(true);

		dieVerwaltung.getDerLehrer().setDerTermin(t);		

		//Fge den Termin zur terminliste des Lehrers
		dieVerwaltung.getDerLehrer().addTermin(t);

		//Fge Datensatz in Alle Termine ein
		alleDaten.addZuAlleTermine(l, e, t.getDerZeitraum());

		//Ausgabe: Erzeuge eine Meldung
		String newline = "\n";
		String mMeldung = "Ihr Termin im Zeitraum "+t.toString()+ newline
				+ "mit "+l.getName()+", "+l.getVorname()+ newline
				+"wurde fr Sie ("+ e.toString()+") reserviert."+newline
				+"Dieser Termin ist nun belegt!";

		//AUSGABE der Meldung in einem Fenster
		JOptionPane.showMessageDialog(null, mMeldung);
	}

	//*#######Terminvereinbarung#####
	private void termin_vereinbaren(){

		//HIER FEHLT QUELLCODE
	}

	//+++++++++++LEHRER+++++++++++++++++++++++++
	//*#######Lehrer hinzufgen#####
	private void lehrer_hinzufuegen(){
		//Eingabewerte in lokale Attribute bernehmen
		String mName = tfName_l.getText();
		String mVorname = tfVorname_l.getText();
		String mRaum = tfRaum.getText();
		String mKuerzel = tfKuerzel.getText();
		String mKlasse = tfKlasse.getText();


		//Ermittele Lehrerliste
		ArrayList<Lehrer> dieLehrerListe = dieVerwaltung.getLehrerliste();

		//Durchlaufe die Lehrerliste des Lehrers	
		end_for:
			for(int i = 0; i< dieLehrerListe.size(); i++){
				Lehrer mLehrer_aus_Liste = dieLehrerListe.get(i);
				Lehrer mLehrer = new Lehrer(mName, mVorname, mKuerzel);

				//Fr den Fall, dass die Lehrerliste noch leer ist
				if(dieLehrerListe.isEmpty()){
					//Soll der Lehrer in der Lehrerliste ergnzt werden
					mLehrer.setIst_Lehrer(true);
					mLehrer.setIn_raum(mRaum);
					mLehrer.setKlassenlehrer_von(mKlasse);
					dieVerwaltung.addLehrer(mLehrer);	
					l_eingefuegt = true;
					break end_for;
					//Fr den Fall dass der eingegebene Name des Lehrer mit dem der Liste bereinstimmt					
				}else if((mLehrer.getName().equals(mLehrer_aus_Liste.getName()))){		
					//AUSGABE der Meldung in einem Fenster
					zeigeMeldung("Der Lehrer mit dem Name ["+ mLehrer.getName()+"] existiert!");	
					break end_for;

					//Fr den Fall dass der Lehrer noch nicht eingefgt wurde
				}else if(l_eingefuegt==false){	

					//Und der eingegebene Name mit dem aus der Liste nicht bereinstimmt
					if(!(mLehrer.getName().equals(mLehrer_aus_Liste.getName()))){
						//Soll der Lehrer in der Lehrerliste ergnzt werden
						mLehrer.setIst_Lehrer(true);
						mLehrer.setIn_raum(mRaum);
						mLehrer.setKlassenlehrer_von(mKlasse);	
						dieVerwaltung.setDerLehrer(mLehrer);
						dieVerwaltung.addLehrer(mLehrer);
						//AUSGABE der Meldung in einem Fenster
						zeigeMeldung("Der Lehrer wurde der Lehrerliste ["+ mLehrer.toString()+"] hinzugefgt!");
						initialisiereCBLehrerliste();
						l_eingefuegt = true;	
						break end_for;
					}
				}else{	
					//AUSGABE der Meldung in einem Fenster
					zeigeMeldung("Der Lehrer ["+ mLehrer.toString()+"] wurde bereits zuvor in der Lehrerliste ergnzt!");
					break end_for;
				}					
			}

		//Testausgabe der Lehrerliste
		System.out.println(this.alleDaten.ausgabeLehrerliste());	
	}
	
	//#####Lehrerdaten ndern#########
	public void lehrer_aendern(){
		//EINGABE
		String mName = leseName_l();
		String mVorname = leseVorname_l();
		String mKuerzel = leseKuerzel();
		String mKlasse = leseKlasse();
		String mRaum = leseRaum();
		String mMeldung = new String();

		ArrayList<Lehrer> dieLehrerliste = dieVerwaltung.getLehrerliste();
		end_for:
		for(int i = 0; i < dieLehrerliste.size();i++ ){
			Lehrer lehrer_aus_liste = dieLehrerliste.get(i);
			if(dieLehrerliste.isEmpty()){
				Lehrer mLehrer = new Lehrer(mName,mVorname,mKuerzel);
				mLehrer.setKlassenlehrer_von(mKlasse);
				mLehrer.setIn_raum(mRaum);
				dieVerwaltung.setDerLehrer(mLehrer);
				dieLehrerliste.add(mLehrer);
				initialisiereCBLehrerliste();
				mMeldung = 	"Der Lehrer "+mLehrer+" wurde hinzugefgt!";
				z_eingefuegt = true;
				break end_for;
			} else if((lehrer_aus_liste.getName().equals(mName))||lehrer_aus_liste.getKuerzel().equals(mKuerzel)){			
					Lehrer mLehrer = new Lehrer(mName,mVorname,mKuerzel);
					mLehrer.setKlassenlehrer_von(mKlasse);
					mLehrer.setIn_raum(mRaum);
					dieVerwaltung.setDerLehrer(mLehrer);
					dieLehrerliste.remove(i);
					dieLehrerliste.add(i, mLehrer);
					initialisiereCBLehrerliste();
					mMeldung = 	"Die Lehrerdaten "+mLehrer+" wurden gendert!";
					z_eingefuegt = true;
					break end_for;
			}
			
		}
		zeigeMeldung(mMeldung);
	}

	//#####Lehrer suchen#########
	public void lehrer_suchen(){
		//EINGABE
		String mName = leseName_l();
		String mVorname = leseVorname_l();
		String mKuerzel = leseKuerzel();
		String mKlasse = leseKlasse();
		String mRaum = leseRaum();

		ArrayList<Lehrer> dieLehrerliste = dieVerwaltung.getLehrerliste();

		//VERARBEITUNG
		end_for:
			for(int i = 0; i < dieLehrerliste.size();i++ ){
				Lehrer mLehrer_aus_liste = dieVerwaltung.holeLehrer(i);
				try{
					if(mLehrer_aus_liste.getName().equals(mName)){
						dieVerwaltung.setDerLehrer(mLehrer_aus_liste);
						zeigeMeldung("Der Lehrer mit dem Namen: "+dieVerwaltung.getDerLehrer().getName()+" wurde gefunden!");
						schreibeLehrer();
						break end_for;
					}else if(mLehrer_aus_liste.getKuerzel().equals(mKuerzel)){
						dieVerwaltung.setDerLehrer(mLehrer_aus_liste);
						zeigeMeldung("Der Lehrer mit dem Krzel: "+dieVerwaltung.getDerLehrer().getKuerzel()+" wurde gefunden!");
						schreibeLehrer();
						break end_for;
					}else if(mLehrer_aus_liste.getVorname().equals(mVorname)){
						dieVerwaltung.setDerLehrer(mLehrer_aus_liste);
						zeigeMeldung("Der Lehrer mit dem Vorname: "+dieVerwaltung.getDerLehrer().getVorname()+" wurde gefunden!");
						schreibeLehrer();
						break end_for;
					}else if(mLehrer_aus_liste.getKlassenlehrer_von().equals(mKlasse)){
						dieVerwaltung.setDerLehrer(mLehrer_aus_liste);
						zeigeMeldung("Der Klassenlehrer der Klasse: "+dieVerwaltung.getDerLehrer().getKlassenlehrer_von()+" wurde gefunden!");
						schreibeLehrer();
						break end_for;
					}else if(mLehrer_aus_liste.getIn_raum().equals(mRaum)){
						dieVerwaltung.setDerLehrer(mLehrer_aus_liste);
						zeigeMeldung("Der Klassenlehrer ist Raum: "+dieVerwaltung.getDerLehrer().getIn_raum()+" zugeordnet!");
						schreibeLehrer();
						break end_for;
					}else{
						zeigeMeldung("Es wurden keine passenden Angaben gefunden!");
					}
				}catch(NullPointerException ex){
					ex.getStackTrace();
				}
			}

	}
	
	//+++++++++++Zeitraum+++++++++++++++++++++++++

		
	//#######Zeitraum hinzufgen#######
	public void zeitraum_hinzufuegen(){
		String mMeldung = new String();
		Uhrzeit mVon = leseVon();
		Uhrzeit mBis = leseBis();

		ArrayList<Zeitraum> dieZeitraeume = dieVerwaltung.getZeitraeume();
		end_for:
		for(int i = 0; i < dieZeitraeume.size();i++ ){
			Zeitraum zeitraum_aus_liste = dieZeitraeume.get(i);
			System.out.println(zeitraum_aus_liste.getVon());
			System.out.println(mVon);
			if(dieZeitraeume.isEmpty()){
				Zeitraum mZeitraum = new Zeitraum(mVon,mBis);
				dieVerwaltung.setZeitraum(mZeitraum);
				dieZeitraeume.add(mZeitraum);
				initialisiereCBZeitraum();
				mMeldung = 	"Der Zeitraum "+mZeitraum+" wurde hinzugefgt!";
				z_eingefuegt = true;
				break end_for;
			} else if((zeitraum_aus_liste.getVon().equals(mVon))){
				if(zeitraum_aus_liste.getBis().equals(mBis)){
					mMeldung = 	"Der Zeitraum ist bereit enthalten!";				
				}else{
					Zeitraum mZeitraum = new Zeitraum(mVon,mBis);
					dieVerwaltung.setZeitraum(mZeitraum);
					dieZeitraeume.add(mZeitraum);
					initialisiereCBZeitraum();
					mMeldung = 	"Der Zeitraum "+mZeitraum+" wurde hinzugefgt!";
					z_eingefuegt = true;
					break end_for;
				}
			}else if(z_eingefuegt == false){
				if(!(zeitraum_aus_liste.getVon().equals(mVon))){
					if(!(zeitraum_aus_liste.getBis().equals(mBis))){
					Zeitraum mZeitraum = new Zeitraum(mVon,mBis);
					dieVerwaltung.setZeitraum(mZeitraum);
					dieZeitraeume.add(mZeitraum);
					initialisiereCBZeitraum();
					mMeldung = 	"Der Zeitraum "+mZeitraum+" wurde hinzugefgt!";
					z_eingefuegt = true;
					break end_for;
					}
				}
				
			}else{
				mMeldung = 	"Der Zeitraum wurde bereits hinzugefgt!";
			}
			
		}
		zeigeMeldung(mMeldung);
	}
	
	//#######Zeitraum bearbeiten#######
	public void zeitraum_bearbeiten(){
		Zeitraum mZeitraum = (Zeitraum) cbmZeitraum.getSelectedItem();
		dieVerwaltung.setZeitraum(mZeitraum);
		Zeitraumfenster mZeitraumaenderung = new Zeitraumfenster(this);
		mZeitraumaenderung.setVisible(true);
	}
	
	
	public void zeitraum_aendern(Uhrzeit pVon, Uhrzeit pBis){
		String mMeldung = new String();
		Uhrzeit mVon = pVon;
		Uhrzeit mBis = pBis;

		ArrayList<Zeitraum> dieZeitraeume = dieVerwaltung.getZeitraeume();
		end_for:
		for(int i = 0; i < dieZeitraeume.size();i++ ){
			Zeitraum zeitraum_aus_liste = dieZeitraeume.get(i);
			if(dieZeitraeume.isEmpty()){
				Zeitraum mZeitraum = new Zeitraum(mVon,mBis);
				dieVerwaltung.setZeitraum(mZeitraum);
				dieZeitraeume.add(mZeitraum);
				initialisiereCBZeitraum();
				mMeldung = 	"Der Zeitraum "+mZeitraum+" wurde hinzugefgt!";
				z_eingefuegt = true;
				break end_for;
			} else if((zeitraum_aus_liste.getVon().equals(mVon))){
				if(zeitraum_aus_liste.getBis().equals(mBis)){
					mMeldung = 	"Der Zeitraum ist bereit enthalten!";				
				}else{
					Zeitraum mZeitraum = new Zeitraum(mVon,mBis);
					dieVerwaltung.setZeitraum(mZeitraum);
					dieZeitraeume.add(i,mZeitraum);
					initialisiereCBZeitraum();
					mMeldung = 	"Der Zeitraum "+mZeitraum+" wurde gendert!";
					z_eingefuegt = true;
					break end_for;
				}
			}else if(z_eingefuegt == false){
				if(!(zeitraum_aus_liste.getVon().equals(mVon))){
					if(!(zeitraum_aus_liste.getBis().equals(mBis))){
					Zeitraum mZeitraum = new Zeitraum(mVon,mBis);
					dieVerwaltung.setZeitraum(mZeitraum);
					dieZeitraeume.add(i,mZeitraum);
					initialisiereCBZeitraum();
					mMeldung = 	"Der Zeitraum "+mZeitraum+" wurde gendert!";
					z_eingefuegt = true;
					break end_for;
					}
				}
				
			}else{
				mMeldung = 	"Der Zeitraum wurde bereits hinzugefgt!";
			}
			
		}
		zeigeMeldung(mMeldung);
	}
	

	//+++++++++++Sonstige+++++++++++++++++++++++++
	private void zeigeMeldung(String pMeldung){
		JOptionPane.showMessageDialog(null, pMeldung);
	}

	private void weiter(int option){
		switch(option){
		case 1:
			lehrerliste_anzeigen();
			break;
		case 2:
			lehrer_aus_liste_loeschen();
			break;
		case 3:
			lehrer_aus_liste_auswaehlen_und_aendern();
			break;
		case 4:
			alle_termine_anzeigen();
			break;
		case 5:
			alle_termine_eines_lehrers();
			break;
		case 6:
			termin_aus_liste_loeschen();
			break;
		case 7:
			termin_aus_liste_auswaehlen_und_aendern();
			break;
		}

	}

	private void lehrerliste_anzeigen(){
		String mAusgabe = alleDaten.ausgabeLehrerliste();
		Anzeigefenster anzeige = new Anzeigefenster(mAusgabe);
		anzeige.setVisible(true);
	}

	private void lehrer_aus_liste_loeschen(){
		//HIER FEHLT QUELLCODE
	}

	private void lehrer_aus_liste_auswaehlen_und_aendern(){
		ArrayList<Lehrer> mLehrerliste = dieVerwaltung.getLehrerliste();
		Aenderungsfenster aenderung = new Aenderungsfenster(this,mLehrerliste);	
		aenderung.setVisible(true);
	}
	

	private void alle_termine_anzeigen(){
		String mAusgabe = alleDaten.ausgabeAllerTermine();
		Anzeigefenster anzeige = new Anzeigefenster(mAusgabe);
		anzeige.setVisible(true);
	}

	private void alle_termine_eines_lehrers(){
		Lehrer mLehrer = dieVerwaltung.getDerLehrer();
		String mAusgabe = alleDaten.ausgabeTerminlisteEinesLehrer(mLehrer);
		Anzeigefenster anzeige = new Anzeigefenster(mAusgabe);
		anzeige.setVisible(true);
	}

	private void termin_aus_liste_loeschen(){
		String mMeldung = new String();
		ArrayList<String> dieTerminliste= alleDaten.getAlleTermine();
		end_for:
			for(int i= 0; i < dieTerminliste.size(); i++ ){
				String derTermin= dieVerwaltung.getDerLehrer().holeTermin(i).toString();
				String termin_aus_liste = dieTerminliste.get(i);
				System.out.println(derTermin);
				System.out.println(termin_aus_liste);
				if(termin_aus_liste.contains(derTermin)){
					dieTerminliste.remove(i);
					mMeldung = "Der Termin ["+derTermin.toString()+"] wurde gelscht!";
					break end_for;
				}else{
					mMeldung = "Der Termin ["+derTermin.toString()+"] ist nicht in der Liste enthalten!";
				}
			}
		zeigeMeldung(mMeldung);
	}

	private void termin_aus_liste_auswaehlen_und_aendern(){
		ArrayList<String> mDieDaten = alleDaten.getAlleTermine();
		Aenderungsfenster aenderung = new Aenderungsfenster(this,mDieDaten);	
		aenderung.setVisible(true);
	}

	private void einstellungen_uebernehmen(){
		//HIER FEHLT QUELLCODE	
	}
}
