package modul;

import java.util.ArrayList;


public class Liste extends Thread{

	//Attribute: Eigenschaften von Ojekten dieser Klasse
	private Lehrer derLehrer;
	private ArrayList<Lehrer> lehrerliste;
	
	private Erziehungsberechtigter derEzb;
	private ArrayList<Erziehungsberechtigter> ezbliste;
		
	private Zeitraum derZeitraum;
	private ArrayList<Zeitraum> zeitraeume;
	
	private Konfiguration dieEinstellung;
	private ArrayList<Konfiguration> einstellungen;
	
	
	//Konstruktor: Erzeugt Objekte dieser Klasse
	public Liste(){
		

						
		//Liste mit Zeitrumen
		this.zeitraeume = new ArrayList<Zeitraum>();
		
		//Test: z1
		this.derZeitraum = new Zeitraum (new Uhrzeit ("12","00"),new Uhrzeit("13","00"));
		this.addZeitraum(derZeitraum);
		
		//Test: z2
		this.derZeitraum = new Zeitraum (new Uhrzeit ("13","00"),new Uhrzeit("14","00"));
		this.addZeitraum(derZeitraum);
		
		//Test: z3
		this.derZeitraum = new Zeitraum (new Uhrzeit ("14","00"),new Uhrzeit("15","00"));
		this.addZeitraum(derZeitraum);
				
		//Test: z4
		this.derZeitraum = new Zeitraum (new Uhrzeit ("15","00"),new Uhrzeit("16","00"));
		this.addZeitraum(derZeitraum);
		
		//Eine neue Lehrerliste
		this.lehrerliste = new ArrayList<Lehrer>();	
				
		//Test: l1
		this.derLehrer = new Lehrer("Janischek","Christine","Janc");
		this.addLehrer(derLehrer);
		
		//Test: l2
		this.derLehrer = new Lehrer("Lutz","Daniel","LutD");
		this.addLehrer(derLehrer);
		
		//Test: l3
		this.derLehrer = new Lehrer("Vogler","Martina","VogM");
		this.addLehrer(derLehrer);	
		
		//Liste mit Erziehungsberechtiger
		this.ezbliste = new ArrayList<Erziehungsberechtigter>();
		
		//Test: e1
		this.derEzb = new Erziehungsberechtigter("Mller","Franz","11c");
		this.addEzb(derEzb);
		
		//Test: e2
		this.derEzb = new Erziehungsberechtigter("Keller","Udo","11g");
		this.addEzb(derEzb);
		
		//Test: e3
		this.derEzb = new Erziehungsberechtigter("Zumboldt","Tim","12a");
		this.addEzb(derEzb);
		
		//Test: e4
		this.derEzb = new Erziehungsberechtigter("Gandt","Arno","13c");
		this.addEzb(derEzb);
				
	}
	
	//GETTER: Ermittelt Eigenschaftswerte eines Objektes einer Klasse


	public Erziehungsberechtigter getDerEzb() {
		return derEzb;
	}

	public ArrayList<Erziehungsberechtigter> getEzbliste() {
		return ezbliste;
	}
	
	public Lehrer getDerLehrer() {
		return derLehrer;
	}

	public ArrayList<Lehrer> getLehrerliste() {
		return lehrerliste;
	}

	public Zeitraum getDerZeitraum() {
		return derZeitraum;
	}

	public ArrayList<Zeitraum> getZeitraeume() {
		return zeitraeume;
	}

	public Konfiguration getDieEinstellung() {
		return dieEinstellung;
	}

	public ArrayList<Konfiguration> getEinstellungen() {
		return einstellungen;
	}
		
	//SETTER: bermittelt Eigenschaftswert an das Objekt der Klasse


	public void setDerLehrer(Lehrer pLehrer) {
		this.derLehrer = pLehrer;
	}
	
	public void setDerEzb(Erziehungsberechtigter pEzb) {
		this.derEzb = pEzb;
	}

	public void setZeitraum(Zeitraum pZeitraum) {
		this.derZeitraum= pZeitraum;
	}

	public void setDieEinstellung(Konfiguration dieEinstellung) {
		this.dieEinstellung = dieEinstellung;
	}

	
	//Sonstige Methoden
	public void addLehrer(Lehrer pLehrer){
		this.lehrerliste.add(pLehrer);
	}
	
	public Lehrer holeLehrer(int pStelle){
		return this.lehrerliste.get(pStelle);
	}

	public boolean pruefeLehrer(Lehrer pLehrer){
		if (this.getLehrerliste().contains(pLehrer)) {
			return true;
		}else{
			return false;
		} // end of if
	}
	
	public void addEzb(Erziehungsberechtigter pEzb){
		this.ezbliste.add(pEzb);
	}
	
	public Erziehungsberechtigter holeEzb(int pStelle){
		return this.ezbliste.get(pStelle);
	}

	public boolean pruefeEzb(Erziehungsberechtigter pEzb){
		if (this.getEzbliste().contains(pEzb)) {
			return true;
		}else{
			return false;
		} // end of if
	}
	
	public void addZeitraum(Zeitraum pZeitraum){
		this.zeitraeume.add(pZeitraum);
	}
	
	public Zeitraum holeZeitraum(int pStelle){
		return this.zeitraeume.get(pStelle);
	}

	public boolean pruefeZeitraum(Zeitraum pZeitraum){
		if (this.getZeitraeume().contains(pZeitraum)) {
			return true;
		}else{
			return false;
		} // end of if
	}
	
	public String ausgabeTerminlisteEinesLehrer(){
		String ausgabe = new String(); 
		String newline = "\n";
		System.out.println("Sie haben:"+ this.getDerLehrer().getTerminliste().size()+ " Termin(e)!");
		for(int i = 0; i < this.getDerLehrer().getTerminliste().size(); i++){				
				Termin t = this.getDerLehrer().holeTermin(i);
				ausgabe = ausgabe.concat(this.getDerLehrer() +", "+this.getDerEzb()+", "+t.toString()+newline);
			}
		return ausgabe;
	}

	public void zuordnen(Lehrer pL, Erziehungsberechtigter pE, Zeitraum pZ){
		this.derLehrer = pL;
		this.derEzb = pE;
		this.derZeitraum = pZ;
	}	
}
