package modul;

import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JButton;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class Zeitraumfenster extends JFrame {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1490780888196868352L;
	private JPanel contentPane;
	private JTextField tfVon;
	private JTextField tfBis;
	Hauptfenster dieOberflaeche;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					Zeitraumfenster frame = new Zeitraumfenster(null);
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public Zeitraumfenster(Hauptfenster o) {
		this.dieOberflaeche = o;
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 330, 225);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(null);
		
		JLabel lbVon = new JLabel("Von: ##.##");
		lbVon.setBounds(24, 29, 74, 14);
		contentPane.add(lbVon);
		
		JLabel lbBis = new JLabel("Bis: ##.##");
		lbBis.setBounds(24, 79, 74, 14);
		contentPane.add(lbBis);
		
		tfVon = new JTextField();
		tfVon.setText(String.valueOf(dieOberflaeche.getVerwaltung().getDerZeitraum().getVon()));
		tfVon.setBounds(111, 26, 108, 20);
		contentPane.add(tfVon);
		tfVon.setColumns(10);
		
		tfBis = new JTextField();
		tfBis.setText(String.valueOf(dieOberflaeche.getVerwaltung().getDerZeitraum().getBis()));
		tfBis.setBounds(111, 76, 108, 20);
		contentPane.add(tfBis);
		tfBis.setColumns(10);
		
		JButton btZeitraum_aendern = new JButton("Zeitraum \u00E4ndern");
		btZeitraum_aendern.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				Uhrzeit mUhrzeit_von = leseVon();
				Uhrzeit mUhrzeit_bis = leseBis();
				Zeitraum mZeitraum = new Zeitraum(mUhrzeit_von,mUhrzeit_bis);
				dieOberflaeche.getVerwaltung().setZeitraum(mZeitraum);		
				dieOberflaeche.schreibeZeitraum();
				dieOberflaeche.zeitraum_aendern(mUhrzeit_von,mUhrzeit_bis);
			}
		});
		btZeitraum_aendern.setBounds(10, 151, 149, 23);
		contentPane.add(btZeitraum_aendern);
		
		JButton btSchliessen = new JButton("Schlie\u00DFen");
		btSchliessen.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				setVisible(false);
			}
		});
		btSchliessen.setBounds(180, 151, 108, 23);
		contentPane.add(btSchliessen);
	}
	
	private Uhrzeit leseVon(){
		String mVon_stunde = String.valueOf(tfVon.getText()).substring(0, 2);
		String mVon_minute = String.valueOf(tfVon.getText()).substring(3, 5);
		Uhrzeit mUhrzeit = new Uhrzeit(mVon_stunde,mVon_minute);

		return mUhrzeit;
	}

	private Uhrzeit leseBis(){
		String mBis_stunde = String.valueOf(tfBis.getText().substring(0, 2));
		String mVon_minute = String.valueOf(tfBis.getText()).substring(3, 5);
		Uhrzeit mUhrzeit = new Uhrzeit(mBis_stunde,mVon_minute);

		return mUhrzeit;
	}
}
