package vererbung;

import java.awt.BorderLayout;
import java.awt.FlowLayout;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JLabel;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JTextArea;
import javax.swing.JScrollPane;

/**
 * @author  chrissi
 */
public class Tierfenster extends JDialog {

	/**
	 * 
	 */
	private static final long serialVersionUID = -9209575948301513641L;
	private final JPanel contentPanel = new JPanel();
	private JTextField tfName;
	private final ButtonGroup bgTier = new ButtonGroup();
	private JRadioButton rbHund;
	private JRadioButton rbKatze; 
	/**
	 * @uml.property  name="dasHauptfenster"
	 * @uml.associationEnd  
	 */
	private Hauptfenster dasHauptfenster = new Hauptfenster();
	private JTextArea taAusgabe;
	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		try {
			Tierfenster dialog = new Tierfenster();
			dialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
			dialog.setVisible(true);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * Create the dialog.
	 */
	public Tierfenster() {
		setBounds(100, 100, 450, 300);
		getContentPane().setLayout(new BorderLayout());
		contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
		getContentPane().add(contentPanel, BorderLayout.CENTER);
		contentPanel.setLayout(null);
		
		rbKatze = new JRadioButton("Katze");
		bgTier.add(rbKatze);
		rbKatze.setBounds(27, 68, 109, 23);
		contentPanel.add(rbKatze);
		
		tfName = new JTextField();
		tfName.setText("tfName");
		tfName.setBounds(27, 41, 136, 20);
		contentPanel.add(tfName);
		tfName.setColumns(10);
		
		JLabel lbName = new JLabel("Bitte Name eingeben:");
		lbName.setBounds(27, 11, 120, 14);
		contentPanel.add(lbName);
		
		rbHund = new JRadioButton("Hund");
		bgTier.add(rbHund);
		rbHund.setBounds(27, 105, 109, 23);
		contentPanel.add(rbHund);
		
		JLabel lbTier = new JLabel("");
		lbTier.setIcon(new ImageIcon(Tierfenster.class.getResource("/vererbung/tiere.png")));
		lbTier.setBounds(253, 11, 171, 197);
		contentPanel.add(lbTier);
		
		JScrollPane scrollPane = new JScrollPane();
		scrollPane.setBounds(27, 135, 216, 83);
		contentPanel.add(scrollPane);
		
		taAusgabe = new JTextArea();
		
		taAusgabe.setText("taAusgabe");
		scrollPane.setViewportView(taAusgabe);
		{
			JPanel buttonPane = new JPanel();
			buttonPane.setLayout(new FlowLayout(FlowLayout.RIGHT));
			getContentPane().add(buttonPane, BorderLayout.SOUTH);
			{
				JButton okButton = new JButton("OK");
				okButton.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent arg0){
						//Eingabe
						dasHauptfenster.leseName(tfName.getText());
						if(bgTier.isSelected(rbHund.getModel())){
							Tier derHund = new Hund(dasHauptfenster.holeLebewesen().getName());
							taAusgabe.setText(derHund.vorstellen());
						}else if(bgTier.isSelected(rbKatze.getModel())){
							Tier dieKatze = new Katze(dasHauptfenster.holeLebewesen().getName());
							taAusgabe.setText(dieKatze.vorstellen());
						}else{
							JOptionPane.showMessageDialog(null, "Bitte whlen Sie eine Tierart aus!");
						}
						
						
					}
				});
				okButton.setActionCommand("OK");
				buttonPane.add(okButton);
				getRootPane().setDefaultButton(okButton);
			}
			{
				JButton closeButton = new JButton("Close");
				closeButton.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent arg0) {
						System.exit(0);
					}
				});
				closeButton.setActionCommand("Close");
				buttonPane.add(closeButton);
			}
		}
	}
}
