package klassen;

import java.awt.BorderLayout;
import java.awt.FlowLayout;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import java.awt.Color;
import javax.swing.JLabel;
import java.awt.Font;
import javax.swing.JTextArea;
import javax.swing.JScrollPane;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.util.ArrayList;

public class Anzeigefenster extends JDialog {

	/**
	 * 
	 */
	private static final long serialVersionUID = 149692041712352969L;
	private final JPanel contentPanel = new JPanel();
	private Hauptfenster dasHauptfenster;
	private JTextArea taAnzeige;
	private JLabel lbBeschreibung;
	private JLabel lbOperation;
	

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		try {
			Anzeigefenster dialog = new Anzeigefenster(null);
			dialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
			dialog.setVisible(true);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * Create the dialog.
	 */
	public Anzeigefenster(Hauptfenster o){
		this.dasHauptfenster = o;
		
		String mOperation = dasHauptfenster.getDerManager().getOperation();
		String mBeschreibung = dasHauptfenster.getDerManager().getBeschreibung();
		
		setBounds(100, 100, 450, 300);
		getContentPane().setLayout(new BorderLayout());
		contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
		getContentPane().add(contentPanel, BorderLayout.CENTER);
		contentPanel.setLayout(null);
		
		lbOperation = new JLabel(mOperation);
		lbOperation.setFont(new Font("Tahoma", Font.PLAIN, 16));
		lbOperation.setBounds(10, 11, 217, 25);
		contentPanel.add(lbOperation);
		
		lbBeschreibung = new JLabel(mBeschreibung);
		lbBeschreibung.setBounds(10, 36, 265, 25);
		contentPanel.add(lbBeschreibung);
		
		JScrollPane scAnzeige = new JScrollPane();
		scAnzeige.setBounds(20, 67, 404, 151);
		contentPanel.add(scAnzeige);
		
		taAnzeige = new JTextArea();
		taAnzeige.setEditable(false);
		schreibeAusgabe();
		scAnzeige.setViewportView(taAnzeige);
		{
			JPanel buttonPane = new JPanel();
			buttonPane.setBackground(Color.WHITE);
			buttonPane.setLayout(new FlowLayout(FlowLayout.RIGHT));
			getContentPane().add(buttonPane, BorderLayout.SOUTH);
			{
				JButton okButton = new JButton("OK");
				okButton.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						setVisible(false);
					}
				});
				okButton.setActionCommand("OK");
				buttonPane.add(okButton);
				getRootPane().setDefaultButton(okButton);
			}
		}
	}


	
	public void schreibeAusgabe(){
		String newline ="\n";
		ArrayList<String> alleDaten = 
				dasHauptfenster.getDerManager().getDieDaten().getDerDatencontainer();		
		
		for(int i = 0; i < alleDaten.size();i++){
			taAnzeige.append(alleDaten.get(i).toString()+newline);			
		}
	}
}
