package klassen;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;



public class CSVSpeicher {
	
	
	//Die Quelldateien zum importieren und konvertieren
	private final String IMPORTSRC = "data.csv";	
	private final String EXPORTSRC = "speicher.csv";
	
	//Array um Datenstze zeilenweise einlesen zu knnen
	private String[] data;
	
	
	public CSVSpeicher(){
	}
	
	public synchronized String importieren(Liste pDaten){
		String mOK="";
		try {
			Liste derDatensatz = pDaten;
			
			BufferedReader in = new BufferedReader(
					new FileReader(this.IMPORTSRC));
			String zeile = null;
			int mStelle = 0;
			while ((zeile = in.readLine()) != null) {
				//Splittet jede Zeile anhand des Trennzeichens	
				data = zeile.split(",");
				//id,deutsch,englisch
				String mIdV = this.data[0].trim();
				String mBezeichnungV = this.data[1].trim();
				String mIdU = this.data[2].trim();	
				String mBezeichnungU = this.data[3].trim();	
				String mIdVon = this.data[4].trim();
				String mVon = this.data[5].trim();	
				String mIdNach = this.data[6].trim();	
				String mNach = this.data[7].trim();	
				
				//ADD Vokabeldaten
				Vokabel dieVokabel = new Vokabel();
				dieVokabel.setIdV(Integer.parseInt(mIdV));
				dieVokabel.setBezeichnungV(mBezeichnungV);
				derDatensatz.setDieVokabel(dieVokabel);
				
				//ADD bersetungdaten
				Uebersetzung dieUebersetzung = new Uebersetzung();
				dieUebersetzung.setBezeichnungV(mBezeichnungU);
				dieUebersetzung.setIdV(Integer.parseInt(mIdU));
				derDatensatz.setDieUebersetzung(dieUebersetzung);
				
				//ADD Von (ist Sprache)
				Von dieSpracheVon = new Von();
				dieSpracheVon.setIdS(mIdVon);
				dieSpracheVon.setBezeichnungS(mVon);
				derDatensatz.setDieSpracheVon(dieSpracheVon);
				
				//ADD Nach (ist Sprache)
				Nach dieSpracheNach = new Nach();
				dieSpracheNach.setIdS(mIdNach);
				dieSpracheNach.setBezeichnungS(mNach);
				derDatensatz.setDieSpracheNach(dieSpracheNach);
				
				//ADD to Listcontainer	(Strings)			
				derDatensatz.getDerDatencontainer()
					.add(derDatensatz.toString());
				
				//Testausgabe auf der Konsole
				System.out.println(derDatensatz.getDerDatencontainer().get(mStelle));				
				mStelle++;
			}
			mOK = "ok";
			in.close();
		}catch(IOException e){
			mOK = "nicht ok";
			e.printStackTrace();
		}
		return mOK;
	}
	
	//In CSV-Datei schreiben
	public synchronized void exportieren(Liste pDaten) 
			throws FileNotFoundException{
		Liste dieDaten = pDaten;

		try {
		
		PrintWriter  out= new PrintWriter (new File (this.EXPORTSRC));	
		int i = 0;
		int anzahl = dieDaten.getDerDatencontainer().size();
			while(i < anzahl){
				String mDatensatz = dieDaten.getDerDatencontainer().get(i);
				out.println(mDatensatz);
				i++;
			}
		out.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}
