package klassen;

import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.JTabbedPane;
import java.awt.Color;

import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.ImageIcon;
import javax.swing.JRadioButton;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import javax.swing.JTextArea;
import javax.swing.JScrollPane;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.DefaultComboBoxModel;
import java.awt.Font;

public class Hauptfenster extends JFrame {

	/**
	 * 
	 */
	private static final long serialVersionUID = 2517600304242962766L;
	private JPanel contentPane;
	private JTextField tfSuchen;
	private JTextField tfVokabel;
	private JTextField tfUebersetzung;
	private JTextField tfIdV;
	private JTextField tfIdU;
	private JTextArea taAnzeige;
	private JRadioButton rbImportieren;
	private JRadioButton rbExportieren;
	private JRadioButton rbAnzeigen;
	private JPanel paTraining;
	private JPanel paVokabelliste;
	private JPanel paSprachen;
	private JPanel paOptionen;
	private JPanel paVokabel;
	private JButton btAuswaehlen;
	private JLabel lbTrain;
	private JComboBox<Sprache> cbVon;
	private JComboBox<Sprache> cbNach;
	private final ButtonGroup bgVokabelliste = new ButtonGroup();
	private DefaultComboBoxModel<Sprache> cbmSprache_Von = new DefaultComboBoxModel<Sprache>();
	private DefaultComboBoxModel<Sprache> cbmSprache_Nach = new DefaultComboBoxModel<Sprache>();	
	private JTabbedPane taVerwaltung;
	private Manager derManager = new Manager(this);
	private JButton btTrain;
	private JLabel lbLoesung;
	private JTextField tfLoesung;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					Hauptfenster frame = new Hauptfenster(null);
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public Hauptfenster(Hauptfenster o) {
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 450, 416);
		contentPane = new JPanel();
		contentPane.setBackground(Color.WHITE);
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(null);

		taVerwaltung = new JTabbedPane(JTabbedPane.TOP);
		taVerwaltung.setBounds(10, 11, 414, 303);
		contentPane.add(taVerwaltung);

		paVokabel = new JPanel();
		taVerwaltung.addTab("Vokabel", null, paVokabel, null);
		paVokabel.setLayout(null);

		JLabel lbVokabel = new JLabel("Vokabel:");
		lbVokabel.setBounds(10, 92, 56, 14);
		paVokabel.add(lbVokabel);

		JLabel lbUebersetzung = new JLabel("\u00DCbersetzung:");
		lbUebersetzung.setBounds(196, 92, 81, 14);
		paVokabel.add(lbUebersetzung);

		tfVokabel = new JTextField();
		tfVokabel.setText("tfVokabel");
		tfVokabel.setBounds(65, 89, 125, 20);
		paVokabel.add(tfVokabel);
		tfVokabel.setColumns(10);

		tfUebersetzung = new JTextField();
		tfUebersetzung.setBackground(Color.WHITE);
		tfUebersetzung.setText("tfUebersetzung");
		tfUebersetzung.setBounds(287, 89, 112, 20);
		paVokabel.add(tfUebersetzung);
		tfUebersetzung.setColumns(10);

		JLabel lbIdV = new JLabel("Vokabelid:");
		lbIdV.setBounds(10, 60, 62, 14);
		paVokabel.add(lbIdV);

		tfIdV = new JTextField();
		tfIdV.setEditable(false);
		tfIdV.setBackground(new Color(211, 211, 211));
		tfIdV.setText("tfIdV");
		tfIdV.setBounds(103, 58, 40, 20);
		paVokabel.add(tfIdV);
		tfIdV.setColumns(10);

		JLabel lbIdU = new JLabel("\u00DCbersetzungsid:");
		lbIdU.setBounds(196, 60, 119, 14);
		paVokabel.add(lbIdU);

		tfIdU = new JTextField();
		tfIdU.setEditable(false);
		tfIdU.setText("tfIdU");
		tfIdU.setBackground(new Color(211, 211, 211));
		tfIdU.setBounds(325, 57, 40, 20);
		paVokabel.add(tfIdU);
		tfIdU.setColumns(10);

		JScrollPane scrollPane = new JScrollPane();
		scrollPane.setBounds(10, 120, 389, 82);
		paVokabel.add(scrollPane);

		taAnzeige = new JTextArea();
		scrollPane.setViewportView(taAnzeige);
		taAnzeige.setText("taAnzeige");

		JButton btNeu = new JButton("Neu");
		btNeu.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				btNeu_ActionPerformed(evt);
			}
		});
		btNeu.setBounds(10, 213, 89, 23);
		paVokabel.add(btNeu);

		JButton btEinfuegen = new JButton("Einf\u00FCgen");
		btEinfuegen.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				btEinfuegen_ActionPerformed(evt);
			}
		});
		btEinfuegen.setBounds(108, 213, 89, 23);
		paVokabel.add(btEinfuegen);

		JButton btSprache_festlegen = new JButton("Sprachen festlegen");
		btSprache_festlegen.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				btSprache_festlegen_ActionPerformed(evt);
			}
		});
		btSprache_festlegen.setBounds(10, 11, 389, 23);
		paVokabel.add(btSprache_festlegen);
		
		JButton btAendern = new JButton("\u00C4ndern");
		btAendern.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				btAendern_ActionPerformed(evt);				
			}
		});
		btAendern.setBounds(207, 213, 89, 23);
		paVokabel.add(btAendern);

		paTraining = new JPanel();
		taVerwaltung.addTab("Training", null, paTraining, null);
		paTraining.setLayout(null);
		
		lbTrain = new JLabel("lbTrain");
		lbTrain.setBackground(Color.YELLOW);
		lbTrain.setFont(new Font("Consolas", Font.ITALIC, 15));
		lbTrain.setBounds(22, 58, 154, 21);
		lbTrain.setOpaque(true);
		paTraining.add(lbTrain);
		
		btTrain = new JButton("Train");
		btTrain.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				btTrain_ActionPerformed(evt);
			}
		});
		btTrain.setBounds(228, 57, 110, 23);
		paTraining.add(btTrain);
		
		lbLoesung = new JLabel("\u00DCbersetzung:");
		lbLoesung.setBounds(22, 100, 110, 14);
		paTraining.add(lbLoesung);
		
		tfLoesung = new JTextField();
		tfLoesung.setText("tfLoesung");
		tfLoesung.setBounds(22, 125, 154, 20);
		paTraining.add(tfLoesung);
		tfLoesung.setColumns(10);
		
		JLabel lbTraining = new JLabel("Gesucht ist die \u00DCbersetzung der Vokabel:");
		lbTraining.setBounds(22, 33, 233, 14);
		paTraining.add(lbTraining);
		
		JButton btCheck = new JButton("Check");
		btCheck.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				btCheck_ActionPerformed(evt);
			}
		});
		btCheck.setBounds(228, 124, 110, 23);
		paTraining.add(btCheck);

		paVokabelliste = new JPanel();
		taVerwaltung.addTab("Vokabelliste", null, paVokabelliste, null);
		paVokabelliste.setLayout(null);

		rbImportieren = new JRadioButton("Importieren von Daten aus einer Datei");
		rbImportieren.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				btAuswaehlen.setText("Importieren");
			}
		});
		bgVokabelliste.add(rbImportieren);
		rbImportieren.setBounds(18, 22, 256, 23);
		paVokabelliste.add(rbImportieren);

		rbExportieren = new JRadioButton("Exportieren von Daten in eine Datei");
		rbExportieren.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				btAuswaehlen.setText("Exportieren");
			}
		});
		bgVokabelliste.add(rbExportieren);
		rbExportieren.setBounds(18, 48, 256, 23);
		paVokabelliste.add(rbExportieren);

		rbAnzeigen = new JRadioButton("Anzeige aller Vokabeln in einer Liste");
		rbAnzeigen.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				btAuswaehlen.setText("Anzeigen");
			}
		});
		bgVokabelliste.add(rbAnzeigen);
		rbAnzeigen.setBounds(18, 75, 277, 23);
		paVokabelliste.add(rbAnzeigen);

		btAuswaehlen = new JButton("Ausw\u00E4hlen");
		btAuswaehlen.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				btAuswaehlen_ActionPerformed(evt); 
			}
		});
		btAuswaehlen.setBounds(18, 161, 148, 23);
		paVokabelliste.add(btAuswaehlen);

		paSprachen = new JPanel();
		taVerwaltung.addTab("Sprachen", null, paSprachen, null);
		paSprachen.setLayout(null);

		JLabel lbSpracheVon = new JLabel("Sprache Von:");
		lbSpracheVon.setBounds(22, 11, 107, 27);
		paSprachen.add(lbSpracheVon);

		JLabel lbSpracheNach = new JLabel("Sprache Nach:");
		lbSpracheNach.setBounds(213, 14, 94, 20);
		paSprachen.add(lbSpracheNach);

		//Initialisierung der Sprachliste (Von)
		cbVon = new JComboBox<Sprache>();		
		cbVon.setModel(cbmSprache_Von);
		initialisiereCBSprachen_Von();		
		cbVon.setBounds(22, 45, 160, 38);
		paSprachen.add(cbVon);

		//Initialisierung der Sprachliste (Nach)
		cbNach = new JComboBox<Sprache>();
		cbNach.setModel(cbmSprache_Nach);
		initialisiereCBSprachen_Nach();
		cbNach.setBounds(213, 45, 169, 38);
		paSprachen.add(cbNach);

		JButton btSprachwahl = new JButton("Sprachen \u00E4ndern");
		btSprachwahl.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				btSprachwahl_ActionPerformed(evt);
			}
		});
		btSprachwahl.setBounds(24, 145, 358, 23);
		paSprachen.add(btSprachwahl);

		paOptionen = new JPanel();
		taVerwaltung.addTab("Optionen", null, paOptionen, null);
		paOptionen.setLayout(null);


		JButton btSuchen = new JButton("Suchen");
		btSuchen.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				btSuchen_ActionPerformed(evt);
			}
		});
		btSuchen.setBounds(335, 333, 89, 23);
		contentPane.add(btSuchen);

		tfSuchen = new JTextField();
		tfSuchen.setText("tfSuchen");
		tfSuchen.setBounds(181, 334, 144, 20);
		contentPane.add(tfSuchen);
		tfSuchen.setColumns(10);
		

		JLabel lblogo = new JLabel("");
		lblogo.setIcon(new ImageIcon(Hauptfenster.class.getResource("/klassen/logo_final.png")));
		lblogo.setBounds(10, 321, 186, 46);
		contentPane.add(lblogo);
	}

	//Hilfsmethoden

	//die Sprachliste (Von_Liste)
	private void initialisiereCBSprachen_Von(){
		for(int i=0; i < derManager.getDieDaten().getSprachliste().size();i++){
			Sprache x = derManager.getDieDaten().getSprachliste().get(i);
			cbmSprache_Von.addElement(x);
		}
	}

	//die Sprachliste (Nach_Liste)
	private void initialisiereCBSprachen_Nach(){
		for(int i=0; i < derManager.getDieDaten().getSprachliste().size();i++){
			Sprache x = derManager.getDieDaten().getSprachliste().get(i);
			cbmSprache_Nach.addElement(x);
		}
	}

	/*EREIGNISSE STEUERN*/
	/*Auswhlen*/
	public void btAuswaehlen_ActionPerformed(ActionEvent evt) {
		//Eingabe
		leseOperation();

		//Verarbeitung
		derManager.auswaehlen();

		//Ausgabe
		schreibeVokabel();

	} // end of btAuswaehlen_ActionPerformed

	/*Neu*/
	public void btNeu_ActionPerformed(ActionEvent evt) {
		/*Eingabe: leere alle relevanten Felder fr 
		 * die Eingabe*/
		
		
		/*Verarbeitung: Ermittle eine neue id und 
		 * bernehme den Wert in ein lokales Attribut*/
		
		
		/*Ausgabe: der Neuen id im id-Feld fr die Vokabel und die 
		 * bersetzung*/
		

	} // end of btNeu_ActionPerformed

	/*Einfuegen*/
	public void btEinfuegen_ActionPerformed(ActionEvent evt) {
		//Eingabe
		leseVokabeldaten();
		leseVon();
		leseNach();

		//Verarbeitung
		derManager.einfuegen();

		//Ausgabe
		schreibeVokabel();

	} // end of btEinfuegen_ActionPerformed
	
	/*Sprache_festlegen*/
	public void btSprache_festlegen_ActionPerformed(ActionEvent evt) {
		
		//Sprung auf den Sprachreiter
		taVerwaltung.setSelectedComponent(paSprachen);
		
		//Ermittlung der Aktuellen Sprache
		String mId_Von = derManager.getDieDaten().getDieSpracheVon().getIdS();
		String mId_Nach = derManager.getDieDaten().getDieSpracheNach().getIdS();
		
		//Anzeige der aktuellen Sprachauswahl
		cbVon.setSelectedIndex(Integer.parseInt(mId_Von));
		cbNach.setSelectedIndex(Integer.parseInt(mId_Nach));
						
	} // end of btSprache_festlegen_ActionPerformed

	/*Sprachwahl*/
	public void btSprachwahl_ActionPerformed(ActionEvent evt) {
		//bermittlung der Eingabewerte
		leseVon();
		leseNach();
		
		taVerwaltung.setSelectedComponent(paVokabel);

	} // end of btSprachewahl_ActionPerformed
	
	/*Suchen*/
	public void btSuchen_ActionPerformed(ActionEvent evt) {
		//Eingabe
		leseSuchwort();

		//Verarbeitung
		derManager.suchen();
		
		
		if(derManager.getTreffer() == 1){
			this.zeigeDialogfenster("Es konnte "+derManager.getTreffer()+ " ermittelt werden!");
			this.schreibeVokabel();
			this.leereAnzeige();
			derManager.ausgebenDatensatz();
		}else{
			this.zeigeDialogfenster("Es konnte kein passender Treffer ermittelt werden!");
			
		}

		//Ausgabe
		taVerwaltung.setSelectedComponent(paVokabel);
		
	} // end of btSuchen_ActionPerformed
	
	/*ndern*/
	public void btAendern_ActionPerformed(ActionEvent evt) {
		//Eingabe
		leseVokabeldaten();

		//Verarbeitung
		derManager.aendern();
		
		if(derManager.getTreffer() == 1){
			this.zeigeDialogfenster("Datensatz "+derManager.getDieDaten().getDieVokabel().getIdV()+ " wurde gendert!");
			this.schreibeVokabel();
			this.leereAnzeige();
			derManager.ausgebenDatensatz();
		}else{
			this.zeigeDialogfenster("Kein Treffer. Es konnte kein nderungen vorgenommen werden!");			
		}

		//Ausgabe
		taVerwaltung.setSelectedComponent(paVokabel);
		
	} // end of btSuchen_ActionPerformed
	
	/*Train*/
	public void btTrain_ActionPerformed(ActionEvent evt) {
		//Eingabe
		derManager.train();
		schreibeTrainobjekt();
		
		String mVokabel = derManager.getDieDaten().getDieVokabel().getBezeichnungV();
		String mSprache_Nach = derManager.getDieDaten().getDieSpracheNach().getBezeichnungS();
		
		String mInput = JOptionPane.showInputDialog("bersetzen Sie: \n"+mVokabel + "\n\n in die Sprache: " +mSprache_Nach);
		
		derManager.setSuchwort(mInput);
		
		btCheck_ActionPerformed(evt);
		
	} // end of btTrain_ActionPerformed
	
	/*Check*/
	public void btCheck_ActionPerformed(ActionEvent evt) {
		//bermittlung der Eingabewerte
		derManager.check();
		
		int mOK = derManager.getTreffer();
		if(mOK == 1){
			zeigeDialogfenster("Richtig!");
			schreibeChecked();
		}else{
			zeigeDialogfenster("Falsch! Probier es doch nocheinmal!");
		}

	} // end of btCheck_ActionPerformed
	
	

	public Manager getDerManager() {
		return derManager;
	}

	public void setDerManager(Manager derManager) {
		this.derManager = derManager;
	}

	public void leereFelder(){
		tfIdV.setText("");
		tfVokabel.setText("");
		tfIdU.setText("");
		tfUebersetzung.setText("");
		taAnzeige.setText("");
	}
	
	public void leereAnzeige(){
		taAnzeige.setText("");
	}
	
	private void leseSuchwort(){
		derManager.setSuchwort(String.valueOf(tfSuchen.getText()));
	}
	
	public String leseLoesung(){
		return tfLoesung.getText();
	}

	private void leseVon(){
		Sprache auswahl = (Sprache) cbmSprache_Von.getSelectedItem();
		Von von = new Von();
		von.setBezeichnungS(auswahl.getBezeichnungS());
		von.setIdS(auswahl.getIdS());
		
		derManager.getDieDaten().setDieSpracheVon(von);
	}
	
	private void leseNach(){
		Sprache auswahl = (Sprache) cbmSprache_Nach.getSelectedItem();
		Nach nach = new Nach();
		nach.setBezeichnungS(auswahl.getBezeichnungS());
		nach.setIdS(auswahl.getIdS());
		
		derManager.getDieDaten().setDieSpracheNach(nach);
	}

	private void leseVokabeldaten(){
		Vokabel dieVokabel = new Vokabel();
		dieVokabel.setIdV(Integer.parseInt(tfIdV.getText()));
		dieVokabel.setBezeichnungV(String.valueOf(tfVokabel.getText()));

		Uebersetzung dieUebersetzung = new Uebersetzung();
		dieUebersetzung.setIdV(Integer.parseInt(tfIdU.getText()));
		dieUebersetzung.setBezeichnungV(String.valueOf(tfUebersetzung.getText()));

		derManager.getDieDaten().setDieVokabel(dieVokabel);
		derManager.getDieDaten().setDieUebersetzung(dieUebersetzung);
	}

	private void leseOperation(){
		if(bgVokabelliste.isSelected(rbImportieren.getModel())){
			derManager.setOperation("Daten importieren");
			derManager.setBeschreibung(rbImportieren.getText());
		}else if(bgVokabelliste.isSelected(rbExportieren.getModel())){
			derManager.setOperation("Daten exportieren");
			derManager.setBeschreibung(rbExportieren.getText());
		}else if(bgVokabelliste.isSelected(rbAnzeigen.getModel())){
			derManager.setOperation("Daten anzeigen");
			derManager.setBeschreibung(rbAnzeigen.getText());
		}
	}

	public void schreibeAusgabe(){
		String mAusgabe = derManager.ausgebenDatensatz();

		taAnzeige.setVisible(true);
		taAnzeige.setText(mAusgabe);
	}

	public void schreibeDatensatz(String pDatensatz){	
		String newline = "\n";
		taAnzeige.append(pDatensatz+newline);	
	}

	public void schreibeVokabel(){ 
		//Ermittle Vokabeldaten
		String mVokabel= derManager.ausgebenVokabel();
		String mUebersetzung = derManager.ausgebenUebersetzung();
		String mIdV = derManager.ausgebenIDV();
		String mIdU = derManager.ausgebenIDU();

		//Schreibe in die Komponente	
		tfIdV.setText(mIdV);
		tfIdU.setText(mIdU);
		tfVokabel.setText(mVokabel);
		tfUebersetzung.setText(mUebersetzung);
	}
	
	public void schreibeTrainobjekt(){
		String mVokabel = derManager.getDieDaten().getDieVokabel().getBezeichnungV();		
		lbTrain.setText(mVokabel);
	}
	
	public void schreibeChecked(){
		String mUebersetzung = derManager.getDieDaten().getDieUebersetzung().getBezeichnungV();
		tfLoesung.setText(mUebersetzung);
	}

	public void zeigeDialogfenster(String pMeldung){
		JOptionPane.showMessageDialog(null,pMeldung);
	}
}
